<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Features\Point;

use Saltus\WP\Plugin\InteractiveGlobes\Saltus\WP\Framework\Infrastructure\Plugin\Registerable;

/**
 * The Point Meta class
 */
class PointProMeta implements Registerable {

	/**
	 * Register Shortcode
	 */
	public function register() {
		add_filter( 'itt_globes/point/model', [ $this, 'add_meta' ] );
	}

	public function add_meta( $point_model ) {

		$options = get_option( 'ittglobes' );

		$actions_default      = apply_filters( 'itt_globes/click_actions', [ 'default' => __('Default', 'interactive-globes') ] );
		$default_colour       = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9';
		$default_hover_colour = isset( $options['defaultHoverColor'] ) && ! empty( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f';



		$point_model['meta']['points_info']['nav']                = 'inline';


		$point_model['meta']['points_info']['sections']['custom'] = [
					'icon'   => 'fa fa-cog fa-lg',
					'title'  => __( 'Customize', 'interactive-globes' ),
					'fields'                 => [
						'useCustom' => [
							'type'     => 'switcher',
							'title'    => __( 'Use Custom Options', 'interactive-globes' ),
							'subtitle' => __( 'Define custom colors and actions.', 'interactive-globes' ),
							'default'  => false,
						],
						'action'         => array(
							'type'       => 'select',
							'title'      => __( 'Click Action', 'interactive-globes' ),
							'desc'       => '',
							'options'    => $actions_default,
							'default'    => 'default',
							'dependency' => [ 'useCustom', '==', true ],
						),
						'type'    => array(
							'type'       => 'button_set',
							'title'      => __( 'Type', 'interactive-globes' ),
							'options'    => [
								'cylinder' => '<i class="fas fa-circle"></i> ' . __( 'Cylinder (default)', 'interactive-globes' ),
								'pin' => '<i class="fas fa-map-pin"></i> ' . __( 'Pin', 'interactive-globes' ),
								'marker' => '<i class="fas fa-map-marker-alt"></i> ' . __( 'Marker', 'interactive-globes' ),
								'image' => '<i class="fas fa-image"></i> ' . __( 'Image', 'interactive-globes' ),
								'flag' => '<i class="fas fa-flag"></i> ' . __( 'Flag', 'interactive-globes' ),
							],
							'default'    => 'cylinder',
							'dependency' => [ 'useCustom', '==', true ],
						),
						'image'                 => [
							'type'    => 'media',
							'library' => 'image',
							'title'   => __( 'Preview Image', 'interactive-globes' ),
							'dependency' => [[ 'useCustom', '==', true ],[ 'type', 'any', 'image,flag' ]],
						],
						'imageOrientation' => array(
							'type'       => 'select',
							'title'      => __( 'Image Orientation', 'interactive-globes' ),
							'options'    => [
								'horizontal' => __( 'Horizontal', 'interactive-globes' ),
								'vertical'   => __( 'Vertical', 'interactive-globes' ),
							],
							'default'    => 'horizontal',
							'dependency' => [ [ 'useCustom', '==', true ], [ 'type', '==', 'image' ] ],
						),
						'animate' => array(
							'type'       => 'switcher',
							'title'      => __( 'Animate', 'interactive-globes' ),
							'desc'       => __( 'Animate the marker.', 'interactive-globes' ),
							'default'    => false,
							'dependency' => [ [ 'useCustom', '==', true ], [ 'type', 'any', 'flag,marker,image' ] ],
						),
						'radius'    => array(
							'type'       => 'spinner',
							'default'    => 20,
							'step'       => 1,
							'title'      => __( 'Size / Radius', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						),
						'altitude'  => array(
							'type'       => 'spinner',
							'default'    => 1,
							'step'       => 1,
							'title'      => __( 'Altitude', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						),
						'color'     => array(
							'type'       => 'color',
							'title'      => __( 'Fill Color', 'interactive-globes' ),
							'default'    => $default_colour,
							'dependency' => [ [ 'useCustom', '==', true ], [ 'type', '!=', 'image' ] ],
						),
						'hover'     => array(
							'type'       => 'color',
							'title'      => __( 'Hover Color', 'interactive-globes' ),
							'default'    => $default_hover_colour,
							'dependency' => [ [ 'useCustom', '==', true ], [ 'type', '!=', 'image' ] ],
						),
					],
				];



		$point_model['meta']['points_info']['sections']['help'] = [
			'title'  => __( 'Help', 'interactive-globes' ),
			'icon'   => 'fa fa-question-circle fa-lg',
			'fields' => array(
						'help' => [
							'type' => 'content',
							'content' => '<p>'.__( 'Use the custom options to define the point type, size, color, and animation.', 'interactive-globes' ).'</p>',
						],

			),
		];
		return $point_model;
	}
}
