<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Assets;

use Saltus\WP\Plugin\InteractiveGlobes\Saltus\WP\Framework\Infrastructure\Service\{
	Service
};

use Saltus\WP\Plugin\InteractiveGlobes\Services\Creatable;

/**
 * Manage Assets like scripts and styles.
 */
class AssetsService implements Service, Creatable {

	private static $instance;

	/**
	 * Instantiate this Service object.
	 *
	 */
	public function __construct( ...$dependencies ) {
		self::$instance = new AssetsCore( ...$dependencies );
	}

	/**
	 * Create a new instance of the service provider
	 *
	 * @return object The new instance
	 */
	public static function create() {
		return self::$instance;
	}
}
