<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Base;

/**
 * common labels
 */
class SafeNL2BR {

	public static function convert( $input ) {
		// Step 1: Normalize all line breaks to \n
		$input = str_replace( [ "\r\n", "\r" ], "\n", $input );

		// Step 2: Remove line breaks between HTML tags
		// This regex replaces line breaks between tags with an empty string
		$input = preg_replace( '/>\s*\n\s*</', '><', $input );

		// Step 3: Split the input into HTML and text parts
		$parts = preg_split( '/(<[^>]*>)/', $input, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY );

		// Step 4: Apply nl2br only to non-HTML parts
		foreach ( $parts as &$part ) {
			if ( ! preg_match( '/^<[^>]+>$/', $part ) ) {
				$part = nl2br( $part );
			}
		}

		// Step 5: Join the parts back together
		return implode( '', $parts );
	}
}
