<?php
use Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Base\SafeNL2BR;

if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
global $ig_fs;
if ( ! isset( $ig_fs ) ) {
	return [];
}
if ( ! $ig_fs->can_use_premium_code() ) {
	return [];
}

use Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Base\Settings;


$options = get_option( 'ittglobes' );

$capability            = isset( $options['capability'] ) && ! empty( $options['capability'] ) ? $options['capability'] : 'page';
$coordinates_editor    = isset( $options['map_field'] ) && $options['map_field'] ? 'map' : 'fieldset';
$tooltip_editor        = isset( $options['tooltip_editor'] ) && ! empty( $options['tooltip_editor'] ) ? $options['tooltip_editor'] : 'textarea';
$action_content_editor = isset( $options['actionContent_editor'] ) && ! empty( $options['actionContent_editor'] ) ? $options['actionContent_editor'] : 'text';
$default_colour        = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9';
$default_border_colour = isset( $options['defaultBorderColor'] ) && ! empty( $options['defaultBorderColor'] ) ? $options['defaultBorderColor'] : '#f0f0f0';
$default_hover_colour  = isset( $options['defaultHoverColor'] ) && ! empty( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f';
$actions_default       = apply_filters( 'itt_globes/click_actions', [ 'default' => __( 'Default', 'interactive-globes' ) ] );
$public_cpts           = isset( $options['public_cpts'] ) && $options['public_cpts'] ? true : false;
$taxonomies            = isset( $options['taxonomies'] ) && ! empty( $options['taxonomies'] ) ? $options['taxonomies'] : false;
$region_options        = [];
$geojson               = false;
$geojson_field_type    = 'select';

$plugin_base_dir    = dirname( __DIR__ );
$settings           = Settings::get( $plugin_base_dir );
$assets_url         = $settings['assets_url'];
$is_cpt_edit_screen = ( isset( $_GET['post'] ) && get_post_type( $_GET['post'] ) === 'itt_globe_region' ) || ( isset( $_GET['post_type'] ) && $_GET['post_type'] === 'itt_globe_region' ) ? true : false;



if ( $is_cpt_edit_screen ) {

	$geojson = isset( $_GET['geojson'] ) ? esc_attr( $_GET['geojson'] ) : $geojson;

	// if there's still nothing
	if ( ! $geojson ) {
		if ( isset( $_GET['post'] ) ) {
			$globe_id = get_post_meta( (int) $_GET['post'], 'globe_id', true );
			$meta     = get_post_meta( $globe_id, 'globe_info', true );
			$geojson  = isset( $meta['regionSource'] ) ? $meta['regionSource'] : 'continents.json';
		} else {
			$geojson = 'continents.json';
		}
	}

	if ( $geojson !== 'custom' ) {
		$geojson_url = $assets_url . '/assets/geojson/' . $geojson;
		if ( ! preg_match( '/(\.json|\.geojson)$/i', $geojson ) ) {
			$geojson_url .= '.json';
		}
	} else {
		$geojson_url = isset( $_GET['geojsonURL'] ) ? esc_attr( $_GET['geojsonURL'] ) : false;
	}

	$geojson = $geojson_url ? $geojson : __( 'URL not found', 'interactive-globes' );

	$request = wp_remote_get( $geojson_url );
	// Decode the JSON file
	if ( ! is_wp_error( $request ) ) {
		$json      = wp_remote_retrieve_body( $request );
		$json_data = json_decode( $json, true );

		if ( json_last_error() !== JSON_ERROR_NONE ) {
			$geojson_field_type = 'text';
		}

		if ( ! empty( $json_data['features'] ) ) {
			foreach ( $json_data['features'] as $shape ) {
				$label                          = isset( $shape['properties'] ) && isset( $shape['properties']['name'] ) ? $shape['properties']['name'] : $shape['id'];
				$region_options[ $shape['id'] ] = esc_attr( $label );
			}
		}
	}
}


$regions = [
	'active'       => true,
	'type'         => 'cpt',
	'name'         => 'itt_globe_region',
	'features'     => [
		'duplicate'     => array(
			'label'      => __( 'Clone Region', 'interactive-globes' ),
			'attr_title' => __( 'Create a copy of this Region', 'interactive-globes' ),
		),
		'single_export' => array(
			'label' => __( 'Download Regions Export File', 'interactive-globes' ),
		),
		'admin_cols'    => array(
			'title',
			'id'       => array(
				'title'      => 'ID',
				'post_field' => 'ID',
			),
			'globe_id' => array(
				'title'    => __( 'Parent Globe', 'interactive-globes' ),
				'function' => function () {
						global $post;
						$globe_id = get_post_meta( $post->ID, 'globe_id', true );
					if ( $globe_id ) {
						$globe_title = get_the_title( $globe_id );
						if ( $globe_title ) {
							echo esc_html( $globe_title );
						} else {
							echo esc_html( $globe_id );
						}
					}
				},
			),
		),
	],
	'supports'     => [
		'title',
		'custom-fields',
	],
	'labels'       => [
		'has_one'     => 'Region',
		'has_many'    => 'Regions',
		'text_domain' => 'interactive-globes',

		// optional, but better for translation
		'overrides'   => array(
			'labels'        => array(
				'name'                  => __( 'Regions', 'interactive-globes' ),
				'singular_name'         => __( 'Region', 'interactive-globes' ),
				'menu_name'             => __( 'Regions', 'interactive-globes' ),
				'name_admin_bar'        => __( 'Regions', 'interactive-globes' ),
				'add_new'               => __( 'Create New', 'interactive-globes' ),
				'add_new_item'          => __( 'Create New Region', 'interactive-globes' ),
				'edit_item'             => __( 'Edit', 'interactive-globes' ),
				'new_item'              => __( 'New Region', 'interactive-globes' ),
				'view_item'             => __( 'View Region', 'interactive-globes' ),
				'view_items'            => __( 'View Regions', 'interactive-globes' ),
				'search_items'          => __( 'Search Regions', 'interactive-globes' ),
				'not_found'             => __( 'No Regions found.', 'interactive-globes' ),
				'not_found_in_trash'    => __( 'No Regions found in Trash.', 'interactive-globes' ),
				'parent_item-colon'     => __( 'Parent Globe:', 'interactive-globes' ),
				'all_items'             => '&#9900; ' . __( 'Regions', 'interactive-globes' ),
				'archives'              => __( 'Region Archives', 'interactive-globes' ),
				'attributes'            => __( 'Region Attributes', 'interactive-globes' ),
				'insert_into_item'      => __( 'Insert into Region', 'interactive-globes' ),
				'uploaded_to_this_item' => __( 'Uploaded to this Region', 'interactive-globes' ),
				'filter_items_list'     => __( 'Filter Region list', 'interactive-globes' ),
				'items_list_navigation' => __( 'Region list navigation', 'interactive-globes' ),
				'items_list'            => __( 'Region list', 'interactive-globes' ),
				'featured_image'        => __( 'Region Cover Image', 'interactive-globes' ),
				'set_featured_image'    => __( 'Set Region Cover Image', 'interactive-globes' ),
				'remove_featured_image' => __( 'Remove Region Cover', 'interactive-globes' ),
				'use_featured_image'    => __( 'Use as Region Cover', 'interactive-globes' ),
			),
			// you can use the placeholders {permalink}, {preview_url}, {date}
			'messages'      => array(
				'post_updated'         => __( 'Region information updated. <a href="{permalink}" target="_blank">View Globe</a>', 'interactive-globes' ),
				'post_updated_short'   => __( 'Region info updated', 'interactive-globes' ),
				'custom_field_updated' => __( 'Custom field updated', 'interactive-globes' ),
				'custom_field_deleted' => __( 'Custom field deleted', 'interactive-globes' ),
				'restored_to_revision' => __( 'Region content restored from revision', 'interactive-globes' ),
				'post_published'       => __( 'Region Published', 'interactive-globes' ),
				'post_saved'           => __( 'Region information saved.', 'interactive-globes' ),
				'post_submitted'       => __( 'Region submitted. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
				'post_schedulled'      => __( 'Region scheduled for {date}. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
				'post_draft_updated'   => __( 'Region draft updated. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
			),
			'bulk_messages' => array(
				'updated_singular'   => __( 'Region updated. Yay!', 'interactive-globes' ),
				'updated_plural'     => __( '%s Region updated. Yay!', 'interactive-globes' ),
				'locked_singular'    => __( 'Region not updated, somebody is editing it', 'interactive-globes' ),
				'locked_plural'      => __( '%s Region not updated, somebody is editing them', 'interactive-globes' ),
				'deleted_singular'   => __( 'Region permanetly deleted. Fahrenheit 451 team was here?', 'interactive-globes' ),
				'deleted_plural'     => __( '%s Region permanently deleted. Why? :(', 'interactive-globes' ),
				'trashed_singular'   => __( 'Region moved to the trash. I\'m sad :(', 'interactive-globes' ),
				'trashed_plural'     => __( '%s Region moved to the trash. Why? :(', 'interactive-globes' ),
				'untrashed_singular' => __( 'Region recovered from trash. Well done!', 'interactive-globes' ),
				'untrashed_plural'   => __( '%s Region saved from the enemies!', 'interactive-globes' ),
			),
			// overrides some of the available button labels and placeholders
			'ui'            => array(
				'enter_title_here' => __( 'Enter Region name here', 'interactive-globes' ),
			),
		),
	],
	'options'      => [
		'public'              => false,
		'publicly_queryable'  => false,
		'exclude_from_search' => true,
		'show_in_rest'        => true,
		'show_in_nav_menus'   => $public_cpts,
		'show_ui'             => true,
		'capability_type'     => $capability,
		'show_in_menu'        => $public_cpts ? 'edit.php?post_type=iglobe' : false,
	],
	'block_editor' => false,
	'meta'         => [
		'region_info'         => [
			'id'                => 'region_info',
			'title'             => __( 'Information', 'interactive-globes' ),
			'nav'               => 'inline',
			'data_type'         => 'serialize',
			'register_rest_api' => true,
			'sections'          => [
				'details' => [
					'title'  => __( 'Details', 'interactive-globes' ),
					'desc'   => __( 'Details.', 'interactive-globes' ),
					'icon'   => 'fa fa-info-circle fa-lg',
					'fields' => array(
						'id'             => [
							'type'        => $geojson_field_type,
							'chosen'      => true,
							'multiple'    => true,
							'placeholder' => __( 'Select a region', 'interactive-globes' ),
							'title'       => __( 'Region Code *', 'interactive-globes' ),
							'options'     => $region_options,
							'default'     => ! empty( $_GET['region_id'] ) ? esc_attr( $_GET['region_id'] ) : '',
							'desc'        => __( 'Fetching regions from: ', 'interactive-globes' ) . $geojson,
							'attributes'  => [
								'class'        => 'region-code-autocomplete',
								'autocomplete' => 'off',
							],
						],
						'tooltipContent' => array(
							'type'  => $tooltip_editor,
							'title' => __( 'Tooltip Content', 'interactive-globes' ),
						),
						'content'        => array(
							'type'     => $action_content_editor,
							'title'    => __( 'Action Content', 'interactive-globes' ),
							'subtitle' => __( 'URL or content to trigger when marker is clicked.', 'interactive-globes' ) . '<br><span class="igm_select_marker_click_reminder">' . __( 'Don\'t forget to select a click action below.', 'interactive-globes' ) . '</span>',
						),
					),
				],
				'custom'  => [
					'title'  => __( 'Customize', 'interactive-globes' ),
					'icon'   => 'fa fa-cog fa-lg',
					'fields' => array(
						'useCustom'   => [
							'type'     => 'switcher',
							'title'    => __( 'Use Custom Options', 'interactive-globes' ),
							'subtitle' => __( 'Define custom colors and actions.', 'interactive-globes' ),
							'default'  => false,
						],
						'action'      => array(
							'type'       => 'select',
							'title'      => __( 'Click Action', 'interactive-globes' ),
							'desc'       => '',
							'options'    => $actions_default,
							'default'    => 'default',
							'dependency' => [ 'useCustom', '==', true ],
						),
						'color'       => array(
							'type'       => 'color',
							'title'      => __( 'Fill Color', 'interactive-globes' ),
							'default'    => $default_colour,
							'dependency' => [ 'useCustom', '==', true ],
						),
						'hover'       => array(
							'type'       => 'color',
							'title'      => __( 'Hover Color', 'interactive-globes' ),
							'default'    => $default_hover_colour,
							'dependency' => [ 'useCustom', '==', true ],
						),
						'strokeColor' => array(
							'type'       => 'color',
							'title'      => __( 'Border Color', 'interactive-globes' ),
							'desc'       => __( 'This color will be used for the border of this individual region.<br>WARNING: The region shape borders will overlap, so this region border might not be visible on all sides of the region if the neighbouring regions have a different color.', 'interactive-globes' ),
							'default'    => $default_border_colour,
							'dependency' => [ 'useCustom', '==', true ],
						),
					),
				],
			],
		],
		'relationship_region' => [
			'id'                => 'region_globe',
			'title'             => __( 'Globe rel', 'interactive-globes' ),
			'class'             => isset( $_GET['iframe'] ) ? 'hidden' : '',
			'register_rest_api' => true,
			'sections'          => [
				'details' => [
					'fields' => array(
						'globe_id'        => [
							'type'              => 'number',
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'attributes'        => [ 'id' => 'globe_id_number' ],
							'class'             => 'hidden',
							'register_rest_api' => true,
						],
						'globe_id_select' => array(
							'placeholder'       => __( 'Select a Parent Globe', 'interactive-globes' ),
							'attributes'        => [ 'id' => 'globe_id_select' ],
							'type'              => 'select',
							'options'           => 'pages',
							'query_args'        => array(
								'post_type'      => 'iglobe',
								'posts_per_page' => -1,
								'post_status'    => 'any',
							),
							'class'             => isset( $_GET['iframe'] ) ? 'hidden' : '',
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'register_rest_api' => true,
						),
					),
				],
			],
		],
	],
];

/*
// if taxonomy is enabled
if( $taxonomies ) {

	$fields = [];

	foreach ($taxonomies as $k => $taxonomy) {

		$fieldset = array(
			'type'   => 'fieldset',
			'title'  => $taxonomy['name'],
			'fields' => []
		);

		$id = ! empty( $taxonomy['slug'] ) ? sanitize_title( $taxonomy['slug'] ) : sanitize_title( $taxonomy['name'] );

		$tax = array(
			'id'         => $id,
			'type'       => 'checkbox',
			'title'      => $taxonomy['name'],
			'options'    => 'categories',
			'query_args' => array(
				'taxonomy'   => $taxonomy['slug'],
				'orderby'  => 'post_title',
				'order'    => 'ASC',
			),
		);

		array_push( $fieldset['fields'], $tax );

		$new = array(
			'id'    => 'add_new_' . $id,
			'type'  => 'text',
			'title' => __( 'Add new', 'interactive-globes' ) . ' ' . $taxonomy['name'],
			'desc'  => __( 'Add new entries separated by commas', 'interactive-globes' )
		);

		array_push( $fieldset['fields'], $new );

		array_push( $fields, $fieldset );

	}

	$regions['meta']['regions_info']['sections']['taxonomies'] = [
		'title'  => __( 'Taxonomies', 'interactive-globes' ),
		'desc'   => __( 'Taxonomies.', 'interactive-globes' ),
		'icon'   => 'fa fa-tags fa-lg',
		'fields' => $fields
	];
}
*/

add_filter( 'itt_globes/meta/remove_meta_box_post_types', 'add_itt_globe_region_post_type', 10, 2 );
function add_itt_globe_region_post_type( $post_types ) {
	$post_types[] = 'itt_globe_region';
	return $post_types;
}

add_filter( 'itt_globes/render/post_setup_meta', 'add_region_to_shortcode', 10, 2 );
function add_region_to_shortcode( $globe_meta, $globe_id ) {

	if ( $globe_id === 0 ) {
		return $globe_meta;
	}
	// if we disable it, no need to run through these
	if ( isset( $globe_meta['regionSource'] ) &&
	$globe_meta['regionSource'] === 'disabled' ) {
		return $globe_meta;
	}

	$args          = [
		'post_type'      => 'itt_globe_region',
		'posts_per_page' => -1,
		'meta_query'     => [
			[
				'key'     => 'globe_id',
				'value'   => $globe_id,
				'compare' => '=',
				'type'    => 'NUMERIC',
			],
		],
	];
	$cpt_list      = [];
	$cpt_query     = new \WP_Query( $args );
	$click_actions = [];
	if ( isset( $globe_meta['regionDefaults']['action'] ) &&
		$globe_meta['regionDefaults']['action'] !== 'none' ) {
		$click_actions[] = $globe_meta['regionDefaults']['action'];
	}

	if ( $cpt_query->have_posts() ) {
		while ( $cpt_query->have_posts() ) {
			$cpt_query->the_post();

			$cpt_id   = get_the_ID();
			$metadata = get_post_meta( $cpt_id );

			if ( empty( $metadata['region_info'][0] ) ) {
				continue;
			}

			$cpt_info            = maybe_unserialize( $metadata['region_info'][0] );
			$cpt_info['post_id'] = $cpt_id;
			$cpt_info['title']   = get_the_title();

			// convert natural line breaks to <br>
			$cpt_info['content']        = SafeNL2BR::convert( $cpt_info['content'] );
			$cpt_info['tooltipContent'] = SafeNL2BR::convert( $cpt_info['tooltipContent'] );
			$cpt_info['globe_id']       = $globe_id;

			if ( empty( $cpt_info['id'] ) ) {
				$cpt_info['id'] = '';
			}
			if ( ! is_array( $cpt_info['id'] ) ) {
				$cpt_info['id'] = explode( ',', $cpt_info['id'] );
			}

			$cpt_list[] = $cpt_info;

			if ( ! empty( $cpt_info['action'] ) &&
				$cpt_info['action'] !== 'none' ) {

				if ( is_array( $cpt_info['action'] ) ) {
					$cpt_info['action'] = $cpt_info['action'][0];
				}

				$click_actions[] = $cpt_info['action'];
			}
		}
	}

	wp_reset_query();

	$globe_meta['regions'] = $cpt_list;

	$globe_meta['enabled_click_actions'] = $globe_meta['enabled_click_actions'] ?? [];
	$globe_meta['enabled_click_actions'] = array_merge( $globe_meta['enabled_click_actions'], $click_actions );
	$globe_meta['enabled_click_actions'] = array_unique( $globe_meta['enabled_click_actions'] );

	return $globe_meta;
}

$regions = apply_filters( 'itt_globes/region/model', $regions );
return $regions;
