<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Features\ClickActions;

if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
use Saltus\WP\Framework\Infrastructure\Plugin\Registerable;
use Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Assets\AssetsCore;
use Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Assets\HasAssets;

class DisplayContentLightbox implements ClickActionOption, Registerable, HasAssets {

	private $option_label;

	public function __construct() {
		$this->option_label   = __( 'Display content in a Lightbox', 'interactive-globes' );
	}

	/**
	 * Register HTML for Action
	 */
	public function register() {

		add_action( 'wp_footer', array( $this, 'footer_content' ) );
	}
	/**
	 * Output footer content
	 *
	 * @return void
	 */
	public function footer_content() {
		if ( ! is_admin() ) {
			// no need to output anything for now
			// echo '<div class="itt_globe_content_footer"></div>';
		}
	}


	public function get_option() {
		return $this->option_label;
	}

	public function register_assets( $assets ) {

		if ( ! is_a( $assets, AssetsCore::class ) ) {
			return;
		}
		$local_asset = '/assets/js/vendor/public/glightbox.js';
		$asset_url   = apply_filters( 'itt_globes/assets/public_assets', $local_asset );

		// if same, it didn't get changed, so its a local file
		if ( $asset_url === $local_asset ) {
			$name = $assets->register_script(
				$local_asset,
				[
					'/assets/js/public/globe.js',
					'/assets/js/vendor/public/globe.gl.js',
				],
				true
			);
		} else {
			$name = $assets->register_fullpath_script(
				$asset_url,
				[
					'/assets/js/public/globe.js',
					'/assets/js/vendor/public/globe.gl.js',
				],
				true
			);
		}

		wp_enqueue_script( $name );

		// styles
		$local_asset = '/assets/css/vendor/public/glightbox.css';
		$asset_url   = apply_filters( 'itt_globes/assets/public_assets', $local_asset );
		if ( $asset_url === $local_asset ) {
			$name = $assets->register_style(
				$local_asset,
				[
					'/assets/css/public/itt-globes-style.css',
				],
				true
			);
		} else {
			$name = $assets->register_fullpath_style(
				$asset_url,
				[
					'/assets/css/public/itt-globes-style.css',
				],
				true
			);
		}

		wp_enqueue_style( $name );
	}
}
