<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Features\DotLabel;

use Saltus\WP\Framework\Infrastructure\Plugin\Registerable;

/**
 * The Point Meta class
 */
class DotLabelProMeta implements Registerable {

	/**
	 * Register Shortcode
	 */
	public function register() {
		add_filter( 'itt_globes/dotlabel/model', [ $this, 'add_meta' ] );
	}

	public function add_meta( $model ) {

		$options = get_option( 'ittglobes' );

		$actions_default      = apply_filters( 'itt_globes/click_actions', [ 'default' => __('Default', 'interactive-globes') ] );
		$default_colour       = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9';
		$default_hover_colour = isset( $options['defaultHoverColor'] ) && ! empty( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f';


		// Dot Labels Pro features
		$model['meta']['dotLabels_info']['nav'] = 'inline';
		$model['meta']['dotLabels_info']['sections']['details']['title'] = __( 'Details', 'interactive-globes' );
		$model['meta']['dotLabels_info']['sections']['details']['icon']  = 'fa fa-info-circle fa-lg';

		$model['meta']['dotLabels_info']['sections']['custom'] = array(
			'title'  => __( 'Customize', 'interactive-globes' ),
			'icon'   => 'fa fa-info-circle fa-lg',
			'fields' =>
				array(
					'useCustom'   => [
						'type'     => 'switcher',
						'title'    => __( 'Use Custom Options', 'interactive-globes' ),
						'subtitle' => __( 'Define custom colors and actions.', 'interactive-globes' ),
						'default'  => false,
					],
					'action'         => array(
						'type'    => 'select',
						'title'   => __( 'Click Action', 'interactive-globes' ),
						'desc'    => '',
						'options' => $actions_default,
						'default' => 'default',
						'dependency' => [ 'useCustom', '==', true ],
					),
					'altitude'       => array(
						'type'    => 'spinner',
						'default' => 1,
						'step'    => 1,
						'title'   => __( 'Altitude', 'interactive-globes' ),
						'dependency' => [ 'useCustom', '==', true ],
					),
					'size'           => array(
						'type'    => 'spinner',
						'default' => 20,
						'step'    => 1,
						'title'   => __( 'Label Size', 'interactive-globes' ),
						'dependency' => [ 'useCustom', '==', true ],
					),
					'color'          => array(
						'type'    => 'color',
						'title'   => __( 'Fill Color', 'interactive-globes' ),
						'default' => $default_colour,
						'dependency' => [ 'useCustom', '==', true ],
					),
					'hover'          => array(
						'type'    => 'color',
						'title'   => __( 'Hover Color', 'interactive-globes' ),
						'default' => $default_hover_colour,
						'dependency' => [ 'useCustom', '==', true ],
					),
					'includeDot'     => array(
						'title'   => __( 'Display Dot', 'interactive-globes' ),
						'desc'    => __( 'Display a dot marker next to the text indicating the exact coordinates of the label.', 'interactive-globes' ),
						'type'    => 'switcher',
						'default' => true,
						'dependency' => [ 'useCustom', '==', true ],
					),
					'radius'         => array(
						'type'       => 'spinner',
						'default'    => 20,
						'step'       => 1,
						'title'      => __( 'Dot Radius', 'interactive-globes' ),
						'dependency' => [ [ 'includeDot', '==', true ], [ 'useCustom', '==', true ] ],
					),
					'dotOrientation' => array(
						'type'       => 'select',
						'default'    => 'bottom',
						'options'    => array(
							'bottom' => __( 'Bottom', 'interactive-globes' ),
							'top'    => __( 'Top', 'interactive-globes' ),
							'right'  => __( 'Right', 'interactive-globes' ),
						),
						'title'      => __( 'Dot Orientation', 'interactive-globes' ),
						'dependency' => array( array( 'includeDot', '==', true ), array( 'useCustom', '==', true ) ),
					),
				),
		);

		return $model;
	}
}
