<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Model\Pro;

/**
 * common meta
 */
class MetaTooltip {
	public static function merge( $meta, $settings ) {

		$options               = $settings['options'];
		$template_editor      = isset( $options['template_editor'] ) ? $options['template_editor'] : 'text';


		// PRO tooltip meta
		$meta['globe_info']['sections']['tooltip'] = array(
			'title'  => __( 'Tooltip', 'interactive-globes' ),
			'icon'   => 'fa fa-comment fa-lg',
			'class'  => 'tooltip_tab',
			'fields' => array(
				'tooltip' => [
					'type'   => 'fieldset',
					'fields' => [
						'tooltip_fieldset_title' => [
							'type'    => 'subheading',
							'content' => __( 'Tooltip Visual Settings', 'interactive-globes' ),
						],
						'backgroundColor'        => [
							'type'       => 'color',
							'title'      => __( 'Background color', 'interactive-globes' ),
							'default'    => '#FFFFFF',
						],
						'fontFamily'             => [
							'type'       => 'text',
							'title'      => __( 'Font Family', 'interactive-globes' ),
							'default'    => 'inherit',
						],
						'font'               => [
							'type'       => 'typography',
							'title'      => __( 'Font Settings', 'interactive-globes' ),
							'default' => array(
								'color'       => '#000000',
								'unit'        => 'px',
								'type'        => 'google',
							),
							'font_family' => false,
							'line_height' => false,
							'text_transform' => false,
							'letter_spacing' => false,
							'preview' => false,
						],
						'cornerRadius'           => [
							'type'       => 'spinner',
							'title'      => __( 'Corner radius', 'interactive-globes' ),
							'default'    => '20',
							'unit'       => 'px',
							'validate'   => 'csf_validate_numeric',
						],
						'border'            => [
							'type'       => 'border',
							'title'      => __( 'Border', 'interactive-globes' ),
							'all'        => true,
							'default' => array(
								'top'    => '4',
								'right'  => '4',
								'bottom' => '4',
								'left'   => '4',
								'style'  => 'solid',
								'color'  => '#1e73be',
								'unit'   => 'px',
							),
						],
						'padding'               => [
							'type'       => 'spacing',
							'title'      => __( 'Padding', 'interactive-globes' ),
							'default'  => array(
								'top'    => '8',
								'right'  => '8',
								'bottom' => '8',
								'left'   => '8',
								'unit'   => 'px',
							),
							'desc'       => __( 'Tooltip padding', 'interactive-globes' ),
						],
						'maxWidth'               => [
							'type'     => 'spinner',
							'title'    => __( 'Maximum Width', 'interactive-globes' ),
							'default'  => '',
							'unit'     => 'px',
							'step'     => 10,
							'desc'     => __( 'Leave it blank if you want the tooltip to calculate the size automatically.', 'interactive-globes' ),
							'validate' => 'csf_validate_numeric',
						],
					],
				],

				'tooltipTemplate' => [
					'type'    => $template_editor,
					'title'   => __( 'Tooltip Template', 'interactive-globes' ),
					'default' => '',
					'desc'    => __( 'You can use placeholders with curly brackets {} that exist in your data source.<br>Default value is {tooltipContent}.', 'interactive-globes' ),
				],
				'tooltipOnlyActive' => [
					'type'    => 'switcher',
					'title'   => __( 'Only active regions', 'interactive-globes' ),
					'default' => true,
					'desc'    => __( 'Only display tooltip on entries with data (regions added manually).', 'interactive-globes' ),
				],
			),
		);

		return $meta;
	}
}
