<?php
if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
global $ig_fs;
if ( ! isset( $ig_fs ) ) {
	return [];
}
if ( ! $ig_fs->can_use_premium_code() ) {
	return [];
}

$options = get_option( 'ittglobes' );

$capability            = isset( $options['capability'] ) && ! empty( $options['capability'] ) ? $options['capability'] : 'page';
$coordinates_editor    = isset( $options['map_field'] ) && $options['map_field'] ? 'map' : 'fieldset';
$tooltip_editor        = isset( $options['tooltip_editor'] ) && ! empty( $options['tooltip_editor'] ) ? $options['tooltip_editor'] : 'textarea';
$action_content_editor = isset( $options['actionContent_editor'] ) && ! empty( $options['actionContent_editor'] ) ? $options['actionContent_editor'] : 'text';
$default_colour        = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#CCCCCC';
$public_cpts           = isset( $options['public_cpts'] ) && $options['public_cpts'] ? true : false;

$lines = [
	'active'       => true,
	'type'         => 'cpt',
	'name'         => 'itt_globe_line',
	'features'     => [
		'duplicate'     => array(
			'label'      => __( 'Clone Line', 'interactive-globes' ),
			'attr_title' => __( 'Create a copy of this Line', 'interactive-globes' ),
		),
		'single_export' => array(
			'label' => __( 'Download Lines Export File', 'interactive-globes' ),
		),
		'admin_cols'    => array(
			'title',
			'id' => array(
				'title'      => 'ID',
				'post_field' => 'ID',
			),
			'globe_id' => array(
				'title'      => __( 'Parent Globe', 'interactive-globes' ),
				'function' => function() {
						global $post;
						$globe_id = get_post_meta( $post->ID, 'globe_id', true );
						if ( $globe_id ) {
							$globe_title = get_the_title($globe_id);
							if ($globe_title) {
								echo esc_html($globe_title);
							} else {
								echo esc_html($globe_id);
							}
						}
					},
			),
		),
	],
	'supports'     => [
		'title',
		'custom-fields',
	],
	'labels'       => [
		'has_one'     => 'Line',
		'has_many'    => 'Lines',
		'text_domain' => 'interactive-globes',

		// optional, but better for translation
		'overrides'   => array(
			'labels'        => array(
				'name'                  => __( 'Lines', 'interactive-globes' ),
				'singular_name'         => __( 'Line', 'interactive-globes' ),
				'menu_name'             => __( 'Lines', 'interactive-globes' ),
				'name_admin_bar'        => __( 'Lines', 'interactive-globes' ),
				'add_new'               => __( 'Create New', 'interactive-globes' ),
				'add_new_item'          => __( 'Create New Line', 'interactive-globes' ),
				'edit_item'             => __( 'Edit', 'interactive-globes' ),
				'new_item'              => __( 'New Line', 'interactive-globes' ),
				'view_item'             => __( 'View Line', 'interactive-globes' ),
				'view_items'            => __( 'View Lines', 'interactive-globes' ),
				'search_items'          => __( 'Search Lines', 'interactive-globes' ),
				'not_found'             => __( 'No Lines found.', 'interactive-globes' ),
				'not_found_in_trash'    => __( 'No Lines found in Trash.', 'interactive-globes' ),
				'parent_item-colon'     => __( 'Parent Globe:', 'interactive-globes' ),
				'all_items'             => '&#9900; ' . __( 'Lines', 'interactive-globes' ),
				'archives'              => __( 'Line Archives', 'interactive-globes' ),
				'attributes'            => __( 'Line Attributes', 'interactive-globes' ),
				'insert_into_item'      => __( 'Insert into Line', 'interactive-globes' ),
				'uploaded_to_this_item' => __( 'Uploaded to this Line', 'interactive-globes' ),
				'filter_items_list'     => __( 'Filter Line list', 'interactive-globes' ),
				'items_list_navigation' => __( 'Line list navigation', 'interactive-globes' ),
				'items_list'            => __( 'Line list', 'interactive-globes' ),
				'featured_image'        => __( 'Line Cover Image', 'interactive-globes' ),
				'set_featured_image'    => __( 'Set Line Cover Image', 'interactive-globes' ),
				'remove_featured_image' => __( 'Remove Line Cover', 'interactive-globes' ),
				'use_featured_image'    => __( 'Use as Line Cover', 'interactive-globes' ),
			),
			// you can use the placeholders {permalink}, {preview_url}, {date}
			'messages'      => array(
				'post_updated'         => __( 'Line information updated. <a href="{permalink}" target="_blank">View Globe</a>', 'interactive-globes' ),
				'post_updated_short'   => __( 'Line info updated', 'interactive-globes' ),
				'custom_field_updated' => __( 'Custom field updated', 'interactive-globes' ),
				'custom_field_deleted' => __( 'Custom field deleted', 'interactive-globes' ),
				'restored_to_revision' => __( 'Line content restored from revision', 'interactive-globes' ),
				'post_published'       => __( 'Line Published', 'interactive-globes' ),
				'post_saved'           => __( 'Line information saved.', 'interactive-globes' ),
				'post_submitted'       => __( 'Line submitted. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
				'post_schedulled'      => __( 'Line scheduled for {date}. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
				'post_draft_updated'   => __( 'Line draft updated. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
			),
			'bulk_messages' => array(
				'updated_singular'   => __( 'Line updated. Yay!', 'interactive-globes' ),
				'updated_plural'     => __( '%s Line updated. Yay!', 'interactive-globes' ),
				'locked_singular'    => __( 'Line not updated, somebody is editing it', 'interactive-globes' ),
				'locked_plural'      => __( '%s Line not updated, somebody is editing them', 'interactive-globes' ),
				'deleted_singular'   => __( 'Line permanetly deleted. Fahrenheit 451 team was here?', 'interactive-globes' ),
				'deleted_plural'     => __( '%s Line permanently deleted. Why? :(', 'interactive-globes' ),
				'trashed_singular'   => __( 'Line moved to the trash. I\'m sad :(', 'interactive-globes' ),
				'trashed_plural'     => __( '%s Line moved to the trash. Why? :(', 'interactive-globes' ),
				'untrashed_singular' => __( 'Line recovered from trash. Well done!', 'interactive-globes' ),
				'untrashed_plural'   => __( '%s Line saved from the enemies!', 'interactive-globes' ),
			),
			// overrides some of the available button labels and placeholders
			'ui'            => array(
				'enter_title_here' => __( 'Enter Line name here', 'interactive-globes' ),
			),
		),
	],
	'options'      => [
		'public'              => false,
		'publicly_queryable'  => false,
		'exclude_from_search' => true,
		'show_in_rest'        => true,
		'show_in_nav_menus'   => $public_cpts,
		'show_ui'             => true,
		'capability_type'     => $capability,
		'show_in_menu'        => $public_cpts ? 'edit.php?post_type=iglobe' : false,
	],
	'block_editor' => false,
	'meta'         => [
		'lines_info'        => [
			'id'                => 'lines_info',
			'title'             => __( 'Information', 'interactive-globes' ),
			'nav'               => 'inline',
			'data_type'         => 'serialize',
			'register_rest_api' => true,
			'rest_api_params'   => [
				'minItems' => 2,
			],
			'sections'          => [
				'details' => [
					'title'  => __( 'Details', 'interactive-globes' ),
					'desc'   => __( 'Details.', 'interactive-globes' ),
					'icon'   => 'fa fa-info-circle fa-lg',
					'fields' => [
						'type'    => [
							'type'    => 'button_set',
							'title'   => __( 'Type', 'interactive-globes' ),
							'options' => [
								'manual'  => __( 'Enter manually', 'interactive-globes' ),
								'markers' => __( 'Connect existing markers', 'interactive-globes' ),
							],
							'default' => 'manual',
						],
						'line'    => [
							'type'         => 'repeater',
							'min'          => 2,
							'button_title' => __( 'Add More End Points', 'interactive-globes' ),
							'title'        => __( 'Locations to connect', 'interactive-globes' ),
							'dependency'   => [ 'type', '==', 'manual' ],
							'default'      => array(
								array(
									'coordinates' => array(
										'zoom'      => '2',
										'address'   => '',
										'latitude'  => ! empty( $_GET['latitude'] ) ? (float) $_GET['latitude'] : '',
										'longitude' => ! empty( $_GET['longitude'] ) ? (float) $_GET['longitude'] : '',
									),
								),
								array(
									'coordinates' => array(
										'zoom'      => '2',
										'address'   => '',
										'latitude'  => ! empty( $_GET['prevlatitude'] ) ? (float) $_GET['prevlatitude'] : '',
										'longitude' => ! empty( $_GET['prevlongitude'] ) ? (float) $_GET['prevlongitude'] : '',
									),
								),
							),
							'fields'       => [
								'coordinates' => [
									'type'   => $coordinates_editor,
									'title'  => __( 'Line Info', 'interactive-globes' ),
									'fields' => [
										'zoom'      => array(
											'type'       => 'text',
											'title'      => __( 'zoom', 'interactive-globes' ),
											'class'      => 'geocoding geocoding-hide',
											'attributes' => array(
												'class' => 'geocoding-input',
											),
											'default'    => 2,
										),
										'address'   => array(
											'type'       => 'text',
											'title'      => __( 'address', 'interactive-globes' ),
											'class'      => 'geocoding geocoding-hide',
											'attributes' => array(
												'class' => 'geocoding-input',
											),
										),
										'latitude'  => [
											'type'  => 'text',
											'title' => __( 'Latitude', 'interactive-globes' ),

										],
										'longitude' => [
											'type'  => 'text',
											'title' => __( 'Longitude', 'interactive-globes' ),

										],
									],
								],
							],
						],
						'markers' => [
							'type'         => 'repeater',
							'title'        => __( 'Markers', 'interactive-globes' ),
							'dependency'   => [ 'type', '==', 'markers' ],
							'button_title' => __( 'Add More Markers', 'interactive-globes' ),
							'default'      => array(
								array(
									'marker' => '',
								),
								array(
									'marker' => '',
								),
							),
							'fields'       => [
								'marker' => [
									'type'       => 'select',
									'title'      => __( 'Select Marker', 'interactive-globes' ),
									'options'    => 'pages',
									'query_args' => [
										'post_type'      => [ 'itt_globe_point', 'itt_globe_dotlabel' ],
										'posts_per_page' => -1,
										'meta_query'     => [
											[
												'key'     => 'globe_id',
												'value'   => isset( $_GET['parent_id'] ) ? $_GET['parent_id'] : '',
												'compare' => '=',
											],
										],
									],
								],
							],
						],
					],
				],
				'custom'  => [
					'title'  => __( 'Customize', 'interactive-globes' ),
					'icon'   => 'fa fa-cog fa-lg',
					'fields' => [
						'useCustom'   => [
							'type'     => 'switcher',
							'title'    => __( 'Use Custom Options', 'interactive-globes' ),
							'subtitle' => __( 'Define custom colors and actions.', 'interactive-globes' ),
							'default'  => false,
						],
						'stroke'      => [
							'type'       => 'color',
							'title'      => __( 'Line Color', 'interactive-globes' ),
							'default'    => $default_colour,
							'dependency' => [ 'useCustom', '==', true ],
						],
						'dashLength'  => [
							'type'       => 'spinner',
							'default'    => 100,
							'max'        => 100,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Line Dash', 'interactive-globes' ),
							'desc'       => __( 'The length of the dashed segments in the arc, in terms of relative line length. (100 = full relative line length)', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						],
						'dashGap'     => [
							'type'       => 'spinner',
							'default'    => 100,
							'max'        => 100,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Line Dash Gap', 'interactive-globes' ),
							'desc'       => __( 'The length of the gap between dash segments, in terms of relative line length. ( 0 = no gap, 0.1 = minimum gap, 100 = full relative line lenght )', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						],
						'strokeWidth' => [
							'type'       => 'spinner',
							'default'    => 2,
							'title'      => __( 'Line Width', 'interactive-globes' ),
							'desc'       => __( 'The line’s diameter, in angular degrees', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						],
						'altitude'    => [
							'type'       => 'spinner',
							'default'    => 10,
							'max'        => 100,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Altitude', 'interactive-globes' ),
							'desc'       => __( 'The arc’s maximum altitude, ocurring at the half-way distance between the two points. (0 = 0 altitude (ground line), 100 = globe radius)', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						],
						'animate'     => [
							'type'       => 'spinner',
							'default'    => 0,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Animation speed', 'interactive-globes' ),
							'desc'       => __( 'Time duration (in seconds) to animate the motion of dash positions from the start to the end Region for a full line length. A value of 0 disables the animation. Make sure the Dash Lenght is less than 100 to visualize the animation.', 'interactive-globes' ),
							'dependency' => [ 'useCustom', '==', true ],
						],
					],
				],
			],
		],
		'relationship_line' => [
			'id'                => 'line_globe',
			'title'             => __( 'Globe rel', 'interactive-globes' ),
			'class'             => isset( $_GET['iframe'] ) ? 'hidden' : '',
			'register_rest_api' => true,
			'sections'          => [
				'details' => [
					'fields'       => array(
						'globe_id' => [
							'type'              => 'number',
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'attributes'        => [ 'id' => 'globe_id_number' ],
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'class'             => 'hidden',
							'register_rest_api' => true,
						],
						'globe_id_select'        => array(
							'placeholder'       => __( 'Select a Parent Globe', 'interactive-globes' ),
							'attributes'        => [ 'id' => 'globe_id_select' ],
							'type'              => 'select',
							'options'           => 'pages',
							'query_args'        => array(
								'post_type'      => 'iglobe',
								'posts_per_page' => -1,
								'post_status'    => 'any',
							),
							'class'             => isset ( $_GET['iframe'] ) ? 'hidden' : '',
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'register_rest_api' => true,
						),
					),
				],
			],
		],
	],
];

add_filter( 'itt_globes/meta/remove_meta_box_post_types', 'add_itt_globe_line_post_type', 10, 2 );
function add_itt_globe_line_post_type( $post_types ) {
	$post_types[] = 'itt_globe_line';
	return $post_types;
}

add_filter( 'itt_globes/render/post_setup_meta', 'add_arcline_to_shortcode', 15, 2 );

function add_arcline_to_shortcode( $globe_meta, $globe_id ) {
	$args = [
		'post_type'      => 'itt_globe_line',
		'posts_per_page' => -1,
		'meta_query'     => [
			[
				'key'     => 'globe_id',
				'value'   => $globe_id,
				'compare' => '=',
				'type'    => 'NUMERIC',
			],
		],
	];

	$cpt_list      = [];
	$cpt_query     = new \WP_Query( $args );
	$click_actions = [];

	if ( isset( $globe_meta['arcLineDefaults']['action'] ) &&
		$globe_meta['arcLineDefaults']['action'] !== 'none' ) {
		$click_actions[] = $globe_meta['arcLineDefaults']['action'];
	}

	if ( $cpt_query->have_posts() ) {
		while ( $cpt_query->have_posts() ) {
			$cpt_query->the_post();
			$cpt_id   = get_the_ID();
			$metadata = get_post_meta( $cpt_id );

			if ( empty( $metadata['lines_info'][0] ) ) {
				continue;
			}
			$cpt_info             = maybe_unserialize( $metadata['lines_info'][0] );
			$cpt_info['id']       = $cpt_id;
			$cpt_info['title']    = get_the_title();
			$cpt_info['globe_id'] = $globe_id;

			if ( isset( $cpt_info['type'] ) && $cpt_info['type'] === 'markers' ) {
				if ( isset( $cpt_info['markers'] ) ) {
					$new_arc_line = [
						'type' => 'markers',
						'line' => [],
					];
					foreach ( $cpt_info['markers'] as $marker ) {
						$marker_id = intval( $marker['marker'] );

						$globe_meta['points'] = isset( $globe_meta['points'] ) && is_array( $globe_meta['points'] ) ? $globe_meta['points'] : [];
						// Search in points
						$point = array_filter(
							$globe_meta['points'],
							function ( $item ) use ( $marker_id ) {
								return isset( $item['id'] ) && $item['id'] === $marker_id;
							}
						);
						//
						if ( ! empty( $point ) ) {
							$point                  = array_values( $point );
							$new_arc_line['line'][] = $point[0];
							continue;
						}

						$globe_meta['dotLabels'] = isset( $globe_meta['dotLabels'] ) && is_array( $globe_meta['dotLabels'] ) ? $globe_meta['dotLabels'] : [];
						// Search in dotLabels
						$dot_label = array_filter(
							
							$globe_meta['dotLabels'],
							function ( $item ) use ( $marker_id ) {
								return isset( $item['id'] ) && $item['id'] === $marker_id;
							}
						);

						if ( ! empty( $dot_label ) ) {
							$dot_label              = array_values( $dot_label );
							$new_arc_line['line'][] = $dot_label[0];
							continue;
						}
					}

					// Merge $new_arc_line with $cpt_info
					$new_arc_line = array_merge($cpt_info, $new_arc_line);

					$cpt_list[] = $new_arc_line;
				}
			} else {
				$cpt_list[] = $cpt_info;
			}
			if ( ! empty( $cpt_info['action'] ) &&
				$cpt_info['action'] !== 'none' ) {
				$click_actions[] = $cpt_info['action'];
			}
		}
	}

	wp_reset_query();

	$globe_meta['arcLines'] = $cpt_list;

	$globe_meta['enabled_click_actions'] = $globe_meta['enabled_click_actions'] ?? [];
	$globe_meta['enabled_click_actions'] = array_merge( $globe_meta['enabled_click_actions'], $click_actions );
	$globe_meta['enabled_click_actions'] = array_unique( $globe_meta['enabled_click_actions'] );

	return $globe_meta;
}

// render auto lines
add_action( 'itt_globes/render/post_setup_meta', 'render_auto_lines', 40, 1 );

/**
 * Renders auto lines on the globe based on the provided metadata.
 *
 * This function processes the 'autoLines' configuration from the globe metadata
 * and generates arc lines connecting points or dot labels according to the specified rules.
 * It uses the default arc line settings and merges the newly created lines with existing ones.
 *
 * @param array $meta The globe metadata containing configuration and existing elements.
 * @return array The updated metadata with newly generated arc lines.
 */

function render_auto_lines( $meta ) {

	$source   = isset( $meta['autoLines'] ) ? $meta['autoLines'] : false;
	$defaults = $meta['arcLineDefaults'] ?? [];

	if ( $source && $source['enabled'] === '1' ) {

		if ( ! is_array( $meta['arcLines'] ) ) {
			$meta['arcLines'] = [];
		}

		foreach ( $source['rules'] as $rule ) {
			$meta['arcLines'] = array_merge( $meta['arcLines'], globe_line_create_arc_lines( $meta, $rule, $defaults ) );
		}
	}

	return $meta;
}

/**
 * Creates arc lines based on the provided metadata, rule, and defaults.
 *
 * This function generates arc lines connecting points or dot labels on the globe
 * according to the specified rule. It uses the default arc line settings and
 * creates new arc lines based on the connection type (source or destination).
 *
 * @param array $meta The globe metadata containing points and dot labels.
 * @param array $rule The rule specifying how to connect points or dot labels.
 * @param array $defaults The default settings for arc lines.
 * @return array An array of newly created arc lines.
 */

function globe_line_create_arc_lines( $meta, $rule, $defaults ) {

	$arc_line_defaults = [
		'line'        => [],
		'useCustom'   => '',
		'stroke'      => $defaults['stroke'] ?? '#99d8c9',
		'dashLength'  => $defaults['dashLength'] ?? '100',
		'dashGap'     => $defaults['dashGap'] ?? '100',
		'strokeWidth' => $defaults['strokeWidth'] ?? '2',
		'altitude'    => $defaults['altitude'] ?? '10',
		'animate'     => $defaults['animate'] ?? '0',
		'source'      => 'Auto-generated line',
	];

	$new_arc_lines = [];

	$origin_key   = $rule['rule'] === 'connect_points' ? 'points' : 'dotLabels'; // this is also used as the rule for the origin point
	$origin_id    = $rule['rule'] === 'connect_points' ? 'point' : 'dotLabel';
	$origin_point = null;

	// Find the origin point
	foreach ( $meta[ $origin_key ] as $point ) {
		if ( $point['id'] == $rule[ $origin_id ] ) {
			$origin_point = $point;
			break;
		}
	}

	if ( $origin_point ) {
		// Connect to all other points
		foreach ( $meta[ $origin_key ] as $point ) {
			if ( $point['id'] != $rule[ $origin_id ] ) {

				$new_arc_line = $arc_line_defaults;

				if ( $rule['connection_type'] === 'source' ) {

					$new_arc_line['line'][] = [
						'coordinates' => [
							'latitude'  => $origin_point['coordinates']['latitude'],
							'longitude' => $origin_point['coordinates']['longitude'],
						],
					];
				}

				$new_arc_line['line'][] = [
					'coordinates' => [
						'latitude'  => $point['coordinates']['latitude'],
						'longitude' => $point['coordinates']['longitude'],
					],
				];

				if ( $rule['connection_type'] === 'destination' ) {

					$new_arc_line['line'][] = [
						'coordinates' => [
							'latitude'  => $origin_point['coordinates']['latitude'],
							'longitude' => $origin_point['coordinates']['longitude'],
						],
					];
				}

				$new_arc_lines[] = $new_arc_line;
			}
		}
	}

	return $new_arc_lines;
}


$lines = apply_filters( 'itt_globes/line/model', $lines );
return $lines;
